//+------------------------------------------------------------------+
//|                              Open Price Horizontal Line v1.1.mq4 |
//|                                        Copyright  2011, tigpips |
//|                                                tigpips@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2011, tigpips"
#property link      "tigpips@gmail.com"     
#property indicator_chart_window

extern int OpenHour = 0;
extern int OpenMin = 0;
extern bool UseBarcount = true;
extern int Barcount = 50000;
extern color LineColor = Red;
extern int LineType = 4;
extern bool LabelToggle = true;
extern string Label_font_type = "Arial Bold";
extern int Label_font_size = 11;
extern color Label_text_color = White;
extern bool Show_text_above_line = false;

int label_offset = 6;
int                  ObjectIdx;
int                  DayIdx;
int                  k;
string               ObjName;
string lbl_obj_name;

bool drawn_this_bar=false;
datetime Last_Updated_Time;
int init()
{
   if(Digits == 5)
   {
      label_offset = label_offset * 10;
   }
   return(0);
}

int deinit()
{
   ObjectsDeleteAll();  
   return(0);
}

int start()
{
   int i,limit;

   if(UseBarcount == true)
   {
      limit = Barcount;  
   }
   else
   {
      limit = IndicatorCounted();
   }
   for(i=0; i<limit; i++)
   {
      if(Time[i] == (Last_Updated_Time-86400) || Time[i] == (Last_Updated_Time-259200))
      {
         drawn_this_bar = false;
      }
      if(TimeHour(Time[i])==OpenHour && TimeMinute(Time[i])==OpenMin && drawn_this_bar == false)
      {
         TrendLine(Time[i],Open[i],Time[i]+86400,Open[i],LineColor);
         drawn_this_bar = true;
         Last_Updated_Time = Time[i];   
      }
   }
   return(0);
}
//+------------------------------------------------------------------+

void TrendLine(datetime x1, double y1, datetime x2, double y2, color col)
{
   double label_y_pos;
   ObjectIdx++;
   ObjName="Line" + DoubleToStr(ObjectIdx,0);   
   ObjectCreate(ObjName, OBJ_TREND, 0, x1, y1, x2, y2);
   ObjectSet(ObjName, OBJPROP_STYLE, LineType);
   ObjectSet(ObjName,OBJPROP_COLOR,col);
   ObjectSet(ObjName,OBJPROP_RAY,0);
   if(LabelToggle == true)
   {
      lbl_obj_name = "Label" + DoubleToStr(ObjectIdx,0);  
      if(Show_text_above_line == true)
      {
         label_y_pos = y1 + (label_offset * Point);
      }
      else
      {
         label_y_pos = y1;
      }
      
      if(ObjectFind(lbl_obj_name) != 0)
      {
      ObjectCreate(lbl_obj_name, OBJ_TEXT, 0, x1+43200, label_y_pos);
      ObjectSetText(lbl_obj_name, DoubleToStr(y1,Digits), Label_font_size, Label_font_type, Label_text_color);
      }
      else
      {
      ObjectMove(lbl_obj_name, 0,x1+43200, y1);
      }
   }
}


